/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelTaskletBase;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.certs.RemovableMediaChoiceBean;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class NetInfoChangedTasklet
extends CertMgtPanelTaskletBase
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTNICD";
    private static final String TRACE_MASKF = "XCRTNICF";
    private static final String TRACE_MASKT = "XCRTNICT";
    private static final Locale LOCALE_EN_US = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());

    public NetInfoChangedTasklet() {
        Trace.trace(TRACE_MASKT, "<->NetInfoChangedTasklet()");
    }

    public static void main(String[] args) {
        String curSysDomain = null;
        HashSet<String> curSysStaticIPAddrs = null;
        String curSysShortHostName = null;
        String curCertSubjectDomain = null;
        String curCertSubjectShortHostName = null;
        HashSet<String> curCertDNSList = null;
        HashSet<String> curCertIPAddrs = null;
        curSysShortHostName = "host2";
        curSysDomain = "domain1";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "domain1";
        curCertDNSList = new HashSet<String>();
        curCertDNSList.add("host1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host2";
        curSysDomain = "";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "";
        curCertDNSList = null;
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host2";
        curSysDomain = "domain1";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "";
        curCertDNSList = null;
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host2";
        curSysDomain = null;
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "domain1";
        curCertDNSList = new HashSet();
        curCertDNSList.add("host1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host2";
        curSysDomain = "domain2";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "domain1";
        curCertDNSList = new HashSet();
        curCertDNSList.add("host1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host1";
        curSysDomain = "domain1";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "domain1";
        curCertDNSList = new HashSet();
        curCertDNSList.add("host1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host1";
        curSysDomain = "domain1";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "";
        curCertDNSList = null;
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host1";
        curSysDomain = "";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "domain1";
        curCertDNSList = new HashSet();
        curCertDNSList.add("host1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host1";
        curSysDomain = "domain2";
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = "domain1";
        curCertDNSList = new HashSet();
        curCertDNSList.add("host1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysShortHostName = "host1";
        curSysDomain = null;
        curCertSubjectShortHostName = "host1";
        curCertSubjectDomain = null;
        curCertDNSList = null;
        curSysStaticIPAddrs = null;
        curCertIPAddrs = null;
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = new HashSet<String>();
        curSysStaticIPAddrs.add("1.1.1.1");
        curCertIPAddrs = new HashSet<String>();
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = null;
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("1.1.1.1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = new HashSet();
        curSysStaticIPAddrs.add("1.1.1.1");
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("1.1.1.1");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = null;
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("1.1.1.1");
        curCertIPAddrs.add("2.2.2.2");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = new HashSet();
        curSysStaticIPAddrs.add("1.1.1.1");
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("1.1.1.1");
        curCertIPAddrs.add("2.2.2.2");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = null;
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("2.2.2.2");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = new HashSet();
        curSysStaticIPAddrs.add("1.1.1.1");
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("2.2.2.2");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = null;
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("2.2.2.2");
        curCertIPAddrs.add("3.3.3.3");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
        curSysStaticIPAddrs = new HashSet();
        curSysStaticIPAddrs.add("1.1.1.1");
        curCertIPAddrs = new HashSet();
        curCertIPAddrs.add("2.2.2.2");
        curCertIPAddrs.add("3.3.3.3");
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, null, null, null);
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "->init()");
        Trace.trace(TRACE_MASKT, "<-init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        HashMap redirectData = null;
        Trace.trace(TRACE_MASKT, "->service(" + request + "," + response + ")");
        if (request.isInitialRequest()) {
            redirectData = (HashMap)this.getRedirectData();
            this.handleRedirect(response);
        } else if (request.isCanceled() || request.isDisposed()) {
            Trace.trace(TRACE_MASKF, "terminating the task");
            response.terminate();
        } else {
            String source = null;
            String actionCommand = null;
            Serializable data = null;
            Serializable data2 = null;
            ServerCert certificate = null;
            String internalDeviceName = null;
            ServerCert serverCert = null;
            source = (String)request.getData("Source");
            Trace.trace(TRACE_MASKF, "source for the service() method is: " + source);
            actionCommand = (String)request.getData("Action");
            Trace.trace(TRACE_MASKF, "actionCommand for the service() method is: " + actionCommand);
            data = (Serializable)request.getData("Data");
            Trace.trace(TRACE_MASKF, "data for the service() method is: " + data);
            data2 = (Serializable)request.getData("Data2");
            Trace.trace(TRACE_MASKF, "data2 for the service() method is: " + data2);
            certificate = (ServerCert)request.getData("Cert");
            Trace.trace(TRACE_MASKF, "certificate for the service() method is: " + certificate);
            if (actionCommand.equals("RemovableMediaChoiceOKButton")) {
                internalDeviceName = (String)((Object)data);
                serverCert = (ServerCert)((HashMap)data2).get("CA_SIGNED_SERVER_CERT");
                try {
                    CertMgtPanelUtils.createCSR(response, this, internalDeviceName, serverCert, 1, null);
                }
                catch (MediaDeviceException e) {
                    CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0036"), response, this);
                    response.noAction();
                }
                catch (MediaServicesUtilException e) {
                    if (e.getErrorType() != 11) {
                        CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0056"), response, this);
                    }
                    response.noAction();
                }
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in service(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 2).log();
                response.noAction();
            }
        }
        Trace.trace(TRACE_MASKT, "<-service(...)");
    }

    public void logException(Throwable throwable) {
        new FrameworkLog(CertMgtConstants.LOG_INFO, 5, throwable).log();
    }

    private void handleRedirect(PanelTaskletResponse response) {
        ServerCert serverCert = null;
        try {
            serverCert = new ServerCert(CertUtils.getConfiguredServerCertFileName());
        }
        catch (HException e) {
            response.noAction();
            return;
        }
        catch (FileNotFoundException e) {
            response.noAction();
            return;
        }
        String curCertSubjectShortHostName = null;
        String curCertSubjectDomain = null;
        HashSet curCertIPAddrs = null;
        HashSet curCertDNSList = null;
        CertPrincipal curCertSubject = null;
        String curCertSubjectHostName = null;
        curCertSubject = serverCert.getSubject();
        if (curCertSubject != null && (curCertSubjectHostName = curCertSubject.getHostName()) != null) {
            curCertSubjectShortHostName = CertUtils.getShortHostName(curCertSubjectHostName);
            curCertSubjectDomain = CertUtils.getDomainName(curCertSubjectHostName);
        }
        curCertDNSList = serverCert.getAlternateDNSNames();
        curCertIPAddrs = serverCert.getIPAddresses();
        String curSysShortHostName = null;
        String curSysDomain = null;
        HashSet<String> curSysStaticIPAddrs = null;
        NetworkSettings networkSettings = null;
        NetworkInfo networkInfo = null;
        NetworkInterfaceInformation curInterfaceInfo = null;
        String curIPAddr = null;
        List networkInterfaceInfo = null;
        curSysStaticIPAddrs = new HashSet<String>();
        networkSettings = NetworkSettings.getNetworkSettings();
        if (networkSettings != null) {
            networkInfo = networkSettings.getNetworkInfo();
            if (networkInfo != null) {
                curSysShortHostName = networkInfo.getComputerName();
                curSysDomain = networkInfo.getDomainName();
            }
            if ((networkInterfaceInfo = networkSettings.getNetworkInterfaceInfo()) != null) {
                Iterator i = networkInterfaceInfo.iterator();
                while (i.hasNext()) {
                    curInterfaceInfo = (NetworkInterfaceInformation)i.next();
                    if (curInterfaceInfo == null || curInterfaceInfo.isDhcpClient() || (curIPAddr = curInterfaceInfo.getIpAddr()) == null || curIPAddr.length() <= 0) continue;
                    curSysStaticIPAddrs.add(curIPAddr);
                }
            }
        }
        NetInfoChangedTasklet.handleNetworkInfoChange(curSysDomain, curSysStaticIPAddrs, curSysShortHostName, curCertSubjectDomain, curCertSubjectShortHostName, curCertDNSList, curCertIPAddrs, serverCert, response, this);
    }

    private static void handleNetworkInfoChange(String curSysDomain, HashSet curSysStaticIPAddrs, String curSysShortHostName, String curCertSubjectDomain, String curCertSubjectShortHostName, HashSet curCertDNSList, HashSet curCertIPAddrs, ServerCert serverCert, PanelTaskletResponse response, NetInfoChangedTasklet tasklet) {
        block58: {
            Iterator i;
            boolean curSysShortHostNameExistsInDNSList = false;
            String curSysStaticIPAddr = null;
            String curCertIPAddr = null;
            ArrayList<String> addList = null;
            ArrayList<String> removeList = null;
            boolean addDomainToSubject = false;
            boolean removeDomainFromSubject = false;
            boolean replaceDomainInSubject = false;
            boolean addShortHostNameToDNSList = false;
            boolean removeShortHostNameFromDNSList = false;
            boolean replaceShortHostNameInSubject = false;
            boolean removeOldSubjectShortHostNameFromDNSList = false;
            StringBuffer changes = null;
            UserContext userContext = null;
            Locale clientLocale = null;
            Object[] subs = null;
            boolean shutdownStarted = false;
            boolean isSelfSigned = false;
            if (response == null) {
                System.out.println("Called handleNetworkInfoChange() with the following arguments:");
                System.out.println("    curSysDomain = " + curSysDomain);
                if (curSysStaticIPAddrs == null) {
                    System.out.println("    curSysStaticIPAddrs = null");
                } else {
                    System.out.println("    curSysStaticIPAddrs = the following elements:");
                    i = curSysStaticIPAddrs.iterator();
                    while (i.hasNext()) {
                        System.out.println("       " + i.next());
                    }
                }
                System.out.println("    curSysShortHostName = " + curSysShortHostName);
                System.out.println("    curCertSubjectDomain = " + curCertSubjectDomain);
                System.out.println("    curCertSubjectShortHostName = " + curCertSubjectShortHostName);
                if (curCertDNSList == null) {
                    System.out.println("    curCertDNSList = null");
                } else {
                    System.out.println("    curCertDNSList = the following elements:");
                    i = curCertDNSList.iterator();
                    while (i.hasNext()) {
                        System.out.println("       " + i.next());
                    }
                }
                if (curCertIPAddrs == null) {
                    System.out.println("    curCertIPAddrs = null");
                } else {
                    System.out.println("    curCertIPAddrs = the following elements:");
                    i = curCertIPAddrs.iterator();
                    while (i.hasNext()) {
                        System.out.println("       " + i.next());
                    }
                }
                System.out.println("    serverCert = " + serverCert);
                System.out.println("    response = " + response);
                System.out.println("");
            }
            if (curCertDNSList != null && curCertDNSList.contains(curSysShortHostName)) {
                curSysShortHostNameExistsInDNSList = true;
            }
            if (curSysDomain != null && curSysDomain.length() > 0) {
                if (curCertSubjectDomain == null || curCertSubjectDomain.length() == 0) {
                    addDomainToSubject = true;
                } else if (!curCertSubjectDomain.equals(curSysDomain)) {
                    replaceDomainInSubject = true;
                }
                if (!curSysShortHostNameExistsInDNSList) {
                    addShortHostNameToDNSList = true;
                }
            } else if (curCertSubjectDomain != null && curCertSubjectDomain.length() > 0) {
                removeDomainFromSubject = true;
                if (curSysShortHostNameExistsInDNSList) {
                    removeShortHostNameFromDNSList = true;
                }
            }
            if (!curSysShortHostName.equals(curCertSubjectShortHostName)) {
                replaceShortHostNameInSubject = true;
                if (!addShortHostNameToDNSList && !curSysShortHostNameExistsInDNSList && (addDomainToSubject || curCertSubjectDomain != null && curCertSubjectDomain.length() > 0)) {
                    addShortHostNameToDNSList = true;
                }
                if (curCertDNSList != null && curCertDNSList.contains(curCertSubjectShortHostName)) {
                    removeOldSubjectShortHostNameFromDNSList = true;
                }
            }
            addList = new ArrayList<String>();
            if (curSysStaticIPAddrs != null) {
                i = curSysStaticIPAddrs.iterator();
                while (i.hasNext()) {
                    curSysStaticIPAddr = (String)i.next();
                    if (curCertIPAddrs != null && curCertIPAddrs.contains(curSysStaticIPAddr)) continue;
                    addList.add(curSysStaticIPAddr);
                }
            }
            removeList = new ArrayList<String>();
            if (curCertIPAddrs != null) {
                i = curCertIPAddrs.iterator();
                while (i.hasNext()) {
                    curCertIPAddr = (String)i.next();
                    if (curSysStaticIPAddrs != null && curSysStaticIPAddrs.contains(curCertIPAddr)) continue;
                    removeList.add(curCertIPAddr);
                }
            }
            if (response != null) {
                userContext = UserContext.getCurrentUserContext();
            }
            if (clientLocale == null) {
                clientLocale = LOCALE_EN_US;
            }
            isSelfSigned = serverCert.isSelfSigned();
            changes = new StringBuffer();
            if (replaceShortHostNameInSubject || replaceDomainInSubject || addDomainToSubject || removeDomainFromSubject) {
                subs = new String[]{CertUtils.makeFQHostName(curCertSubjectShortHostName, curCertSubjectDomain), CertUtils.makeFQHostName(curSysShortHostName, curSysDomain)};
                changes.append(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "SubjectChanged", subs).toString(clientLocale));
                if (response != null) {
                    serverCert.setHostName(CertUtils.makeFQHostName(curSysShortHostName, curSysDomain));
                }
            }
            if (addShortHostNameToDNSList) {
                subs = new String[]{curSysShortHostName};
                changes.append(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "DNSEntryAdded", subs).toString(clientLocale));
                if (response != null) {
                    serverCert.addDNSName(curSysShortHostName);
                }
            }
            if (removeOldSubjectShortHostNameFromDNSList) {
                subs = new String[]{curCertSubjectShortHostName};
                changes.append(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "DNSEntryRemoved", subs).toString(clientLocale));
                if (response != null) {
                    serverCert.removeDNSName(curCertSubjectShortHostName);
                }
            }
            if (removeShortHostNameFromDNSList) {
                subs = new String[]{curSysShortHostName};
                changes.append(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "DNSEntryRemoved", subs).toString(clientLocale));
                if (response != null) {
                    serverCert.removeDNSName(curSysShortHostName);
                }
            }
            subs = new String[1];
            i = addList.iterator();
            while (i.hasNext()) {
                subs[0] = (String)i.next();
                changes.append(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "IPAddrEntryAdded", subs).toString(clientLocale));
                if (response == null) continue;
                serverCert.addIPAddr((String)subs[0]);
            }
            i = removeList.iterator();
            while (i.hasNext()) {
                subs[0] = (String)i.next();
                changes.append(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "IPAddrEntryRemoved", subs).toString(clientLocale));
                if (response == null) continue;
                serverCert.removeIPAddr((String)subs[0]);
            }
            if (response != null) {
                if (changes.length() > 0) {
                    if (isSelfSigned) {
                        if (NetInfoChangedTasklet.userWantsToRegenerateCert(clientLocale, changes.toString(), tasklet)) {
                            try {
                                CertUtils.doInstallSelfSigned(serverCert);
                                CertMgtPanelUtils.showInfoMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0033"), response, tasklet);
                                Trace.trace(TRACE_MASKF, "Replaced certificate successfully.. restarting");
                                try {
                                    shutdownStarted = ShutdownManager.restartApplication(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "netInfoChangedName"), new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "restartReason"), null);
                                }
                                catch (ShutdownInProcessException e) {
                                    shutdownStarted = true;
                                }
                                if (!shutdownStarted) {
                                    Trace.trace(TRACE_MASKF, "Shutdown request rejected by local user");
                                }
                            }
                            catch (HException e) {
                                Trace.trace(TRACE_MASKF, e);
                                CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0034"), response, tasklet);
                            }
                        }
                        response.noAction();
                    } else {
                        HashMap<String, ServerCert> taskletData = null;
                        ArrayList qualifiedDevices = null;
                        if (NetInfoChangedTasklet.userWantsCSRCreated(clientLocale, changes.toString(), tasklet)) {
                            taskletData = new HashMap<String, ServerCert>();
                            taskletData.put("CA_SIGNED_SERVER_CERT", serverCert);
                            try {
                                qualifiedDevices = CertUtils.getRemovableMediaDevices();
                                if (qualifiedDevices.size() > 0) {
                                    response.openModalChild("com.ibm.hwmca.fw.certs.res.CertMgt", "RemovableMediaChoicePanel", new RemovableMediaChoiceBean(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "RemovableMediaChoicePanelIntroLabel"), qualifiedDevices, taskletData, "RemovableMediaChoicePanel"));
                                    break block58;
                                }
                                Trace.trace(TRACE_MASKF, "There are no removable media devices to write the certificate signing request to.");
                                new FrameworkLog(CertMgtConstants.LOG_INFO, 15).log();
                                CertMgtPanelUtils.showErrorMessageBox(new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0040"), response, tasklet);
                                response.noAction();
                            }
                            catch (MediaDeviceException e) {
                                Trace.trace(TRACE_MASKF, "MedisDeviceException caught", e);
                                response.noAction();
                            }
                            catch (HException e) {
                                Trace.trace(TRACE_MASKF, "HException caught", e);
                                response.noAction();
                            }
                        } else {
                            response.noAction();
                        }
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "There are no changes to be made.");
                    response.noAction();
                }
            } else {
                System.out.println("replaceShortHostNameInSubject = " + replaceShortHostNameInSubject);
                System.out.println("replaceDomainInSubject = " + replaceDomainInSubject);
                System.out.println("addDomainToSubject = " + addDomainToSubject);
                System.out.println("removeDomainFromSubject = " + removeDomainFromSubject);
                System.out.println("addShortHostNameToDNSList = " + addShortHostNameToDNSList);
                System.out.println("removeOldSubjectShortHostNameFromDNSList = " + removeOldSubjectShortHostNameFromDNSList);
                System.out.println("removeShortHostNameFromDNSList = " + removeShortHostNameFromDNSList);
                System.out.println("The following IP addresses will be added to the certificate:");
                i = addList.iterator();
                while (i.hasNext()) {
                    System.out.println("   " + i.next());
                }
                System.out.println("The following IP addresses will be removed from the certificate:");
                i = removeList.iterator();
                while (i.hasNext()) {
                    System.out.println("   " + i.next());
                }
                System.out.println("");
                System.out.println("The changes are as follows:");
                System.out.println(changes.toString());
                System.out.println("");
            }
        }
    }

    private static boolean userWantsToRegenerateCert(Locale clientLocale, String changes, PanelTasklet tasklet) {
        boolean result = false;
        String title = null;
        String prompt = null;
        title = new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0042").toString(clientLocale);
        prompt = new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0068").toString(clientLocale) + changes;
        result = CertMgtPanelUtils.showLocalizedQuestionMessageBox(title, prompt, tasklet);
        return result;
    }

    private static boolean userWantsCSRCreated(Locale clientLocale, String changes, PanelTasklet tasklet) {
        boolean result = false;
        String title = null;
        String prompt = null;
        title = new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0042").toString(clientLocale);
        prompt = new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0069").toString(clientLocale) + changes;
        result = CertMgtPanelUtils.showLocalizedQuestionMessageBox(title, prompt, tasklet);
        return result;
    }
}

